﻿/// <reference name="MicrosoftAjax.js"/> 

IComparable = function() { };
IComparable.prototype = {
  compareTo: function(obj) { throw Error.notImplemented(); }  
};
IComparable.registerInterface("IComparable");

Book = function(text) {
    this._text = text;
};
Book.prototype = {
    get_text: function() { return this._text; },
    
    // porównuje tę książkę z inną książką
    // zwraca wartość -1, jeśli długość tekstu tej książki jest mniejsza niż w przypadku obj
    // zwraca wartość 0, jeśli długość tekstu tej książki jest równa długości tekstu książki obj
    // zwraca wartość 1, jeśli długość tekstu tej książki jest większa niż w przypadku obj
    compareTo: function(obj) {
        var objLen = obj.get_text().length;
        var thisLen = this.get_text().length;
        if (thisLen === objLen) {
            return 0;
        } 
        else if (thisLen > objLen) {
            return 1;
        }
        return -1;
    },
    toString: function() { return this._text; }
};
Book.registerClass("Book", null, IComparable);

Newspaper= function(numberOfPages) {
    this._numberOfPages = numberOfPages;
};
Newspaper.prototype = {
    get_numberOfPages: function() { return this._numberOfPages; },
    
    compareTo: function (obj) {
        var objPages = obj.get_numberOfPages();
        if (this._numberOfPages === objPages) {
            return 0;
        }
        else if (this._numberOfPages > objPages) {
            return 1;
        }
        return -1;
    },
    toString: function () { return this._numberOfPages; }
}
Newspaper.registerClass("Newspaper", null, IComparable);

// sortuje wszystko, co implementuje interfejs IComparable
function bubbleSort(arrayOfComparables) {
    var sortedArray = [];
    for (var i=0; i<arrayOfComparables.length; i++) {
        var itemToSort = arrayOfComparables[i];
        // sprawdza, czy interfejs IComparable jest obsługiwany
        if (!IComparable.isImplementedBy(itemToSort)) {
          throw Error.invalidOperation("Element nie implementuje interfejsu IComparable");
        }
            
        for (var j=0; j<sortedArray.length; j++) {
            var itemToCompare = sortedArray[j];

            if (itemToSort.compareTo(itemToCompare) < 0) {
                break;
            }
        }
        Array.insert(sortedArray, j, itemToSort);
    }
    
    return sortedArray;
}

var bookList= [new Book("To jest tekst książki"), new Book("To jest tekst innej książki"), new Book("To jest tekst książki mojego autorstwa"), new Book("To jest tekst książki mojego autorstwa"), new Book("To jest tekst innej książki mojego autorstwa")];
var sortedBooks = bubbleSort(bookList);

var newspaperList = [new Newspaper(15), new Newspaper(154), new Newspaper(22), new Newspaper(65), new Newspaper(1), new Newspaper(16), new Newspaper(87), new Newspaper(69), new Newspaper(44)];
var sortedNewspapers = bubbleSort(newspaperList);

alert (sortedBooks.join(" -- "));
alert (sortedNewspapers.join(" -- "));